/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.dtd.core.parsing.ast.DTDAttListDeclNode;
import com.aptana.dtd.core.parsing.ast.DTDAttributeNode;
import com.aptana.dtd.core.parsing.ast.DTDElementDeclNode;
import com.aptana.dtd.core.parsing.ast.DTDParseRootNode;
import com.aptana.dtd.core.parsing.ast.DTDTreeWalker;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.xml.core.model.AttributeElement;
import com.aptana.xml.core.model.DTDTransformException;
import com.aptana.xml.core.model.ElementElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTDTransformer {
    private List<ElementElement> _elements;
    private List<AttributeElement> _attributes;

    public void transform(String source) throws DTDTransformException {
        try {
            IParseRootNode root = this.parse(source);
            if (root instanceof DTDParseRootNode) {
                NodeCollector collector = new NodeCollector();
                collector.visit((DTDParseRootNode)root);
                this._elements = collector.getElements();
                Collections.sort(this._elements, new Comparator<ElementElement>(){

                    @Override
                    public int compare(ElementElement o1, ElementElement o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this._attributes = collector.getAttributes();
                Collections.sort(this._attributes, new Comparator<AttributeElement>(){

                    @Override
                    public int compare(AttributeElement o1, AttributeElement o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
        }
        catch (Exception e) {
            throw new DTDTransformException(MessageFormat.format("Failed to parse DTD source: {0}", source), e);
        }
    }

    public List<AttributeElement> getAttributes() {
        return CollectionsUtil.getListValue(this._attributes);
    }

    public List<ElementElement> getElements() {
        return CollectionsUtil.getListValue(this._elements);
    }

    protected IParseRootNode parse(String source) throws Exception {
        return ParserPoolFactory.parse((String)"com.aptana.contenttype.dtd", (String)source).getRootNode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeCollector
    extends DTDTreeWalker {
        private Map<String, ElementElement> _elementMap = new HashMap<String, ElementElement>();
        private Set<AttributeElement> _attributes = new HashSet<AttributeElement>();

        private NodeCollector() {
        }

        public List<AttributeElement> getAttributes() {
            return new ArrayList<AttributeElement>(this._attributes);
        }

        public List<ElementElement> getElements() {
            return new ArrayList<ElementElement>(this._elementMap.values());
        }

        public void visit(DTDElementDeclNode node) {
            String elementName = node.getName();
            if (!this._elementMap.containsKey(elementName)) {
                ElementElement element = new ElementElement();
                element.setName(elementName);
                this._elementMap.put(elementName, element);
            }
        }

        public void visit(DTDAttributeNode node) {
            String elementName;
            ElementElement element;
            IParseNode parent = node.getParent();
            if (parent instanceof DTDAttListDeclNode && (element = this._elementMap.get(elementName = ((DTDAttListDeclNode)parent).getName())) != null) {
                String attributeName = node.getName();
                AttributeElement attribute = new AttributeElement();
                attribute.setName(attributeName);
                attribute.setElement(elementName);
                element.addAttribute(attributeName);
                this._attributes.add(attribute);
            }
        }
    }
}

